
close all

% Cyclical component of monthly series
fQUR = readtable('../Data/CPSf_JOLTSq.csv');
fQUR(215:end,:)  = [];
startDate = datenum('01-01-2001');
endDate = datenum('10-01-2018');
fQUR.date = linspace(startDate,endDate,214)';
fQUR.qrt = quarter(fQUR.date);
fQUR.year = year(fQUR.date);
fQUR.qrtD = fQUR.qrt + 10* fQUR.year;

% Cyclical component of quarterly averages
fQUR_qrt = readtable('../Data/CPSf_JOLTSq_qrt.csv');
%fQUR_qrt(73:end,:) = [];
ueQrt = fQUR_qrt.c_lnueRate;
qurQrt = fQUR_qrt.c_lnJTSQUR;

fQUR_qrt_hamilton = readtable('../Data/CPSf_JOLTSq_qrt_hamilton.csv');
ueQrt_hamilton = fQUR_qrt_hamilton.c_lnueRate_hamilton;
qurQrt_hamilton = fQUR_qrt_hamilton.c_lnJTSQUR_hamilton;
%%
figNum = 1;

startDate = datenum('Q1-2001','QQ-YY');
endDate = datenum('Q2-2019','QQ-YY');
dateQrt = linspace(startDate,endDate,74)';

figure(figNum)
plot(dateQrt,100*ueQrt,ls.lineSpec4{:},'LineStyle','-')
hold on
plot(dateQrt,100*qurQrt,ls.lineSpec3{:})
hold off

tick = datenum(2001:1:2019,1,1);
set(gca, 'xtick', tick);
datetick('x', 'yy', 'keepticks');
legend('UE (CPS)','Quits (JOLTS)')
grid on
set(gca, ls.gridLineSpec{:})
set(gca, ls.fontSpec{:})
ylabel('Deviation from Trend (\%)');
ylim([-40 25])
export_fig(figure(figNum),[ls.graphPath 'ue_vs_quits'],'-pdf','-transparent');

[b_hp,~,~,~,stats_hp] = regress(ueQrt,[ones(length(qurQrt),1) qurQrt]);

%% Hamilton detrending
figNum = figNum + 1;

startDate = datenum('Q4-2003','QQ-YY');
endDate = datenum('Q1-2019','QQ-YY');
dateQrt = linspace(startDate,endDate,62)';

figure(figNum)
plot(dateQrt,100*ueQrt_hamilton,ls.lineSpec4{:},'LineStyle','-')
hold on
plot(dateQrt,100*qurQrt_hamilton,ls.lineSpec3{:})
hold off

tick = datenum(2003:1:2019,1,1);
set(gca, 'xtick', tick);
datetick('x', 'yy', 'keepticks');
legend('UE (CPS)','Quits (JOLTS)')
grid on
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})
ylabel('Deviation from Trend (\%)');
ylim([-40 25])

export_fig(figure(figNum),[ls.graphPath 'ue_vs_quits_hamilton'],'-pdf','-transparent');

figNum = figNum + 1;
[b_hamilton,~,~,~,stats_hamilton] = regress(ueQrt_hamilton,[ones(length(qurQrt_hamilton),1) qurQrt_hamilton]);



